
  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Mon Mar 07 16:46:18 2005
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version CRYS_ATP_TST_RC4_Acceptance.c#1:csrc:1
   *  \author doronp
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */



/***** Include Files ******/
#include "CRYS.h"

#include "CRYS_ATP_TST_Defines.h"
#include "CRYS_ATP_TST_UTIL_Funcs.h"
#include "CRYS_ATP_TST_RC4_Acceptance.h"
#include "CRYS_ATP_TST_RC4_Acceptance_test_vectors.h"

#include "DX_VOS_Mem.h"

#if TST_USE_RC4_DATA/*In case no test vectors are selected - code disabled*/

/******** Defines **********/
/******** Enums **********/
/******** Typedefs *********/
/******** Global Data ********/
/***** Private function prototype ********/
/******** Public Functions **********/
/***************************
 * Function Name:                                                           
 *  CRYS_ATP_TST_RC4_Acceptance_NON_integrated      
 * 
 * Inputs:
 *  None
 *
 * Outputs:
 *  CRYSError_t - Function error return                                     
 *
 * Description:                                                                 
 *  This function Is a Acceptance test for RC4 non integrated API's                         
 *  This function Encrypts and Decrypts known vectors using RC4 
 *  Vector sizes used (in bytes) - 16/32/45/512/1536
 *  Key Size used (in bytes)    - 16/32/45/256
 *  This also outputs the results to an output buffer or the same input buffer
 * Algorithm:       
 * 1. Call the CRYS_RC4_Init function to start the encryption/decryption process
 * 2. Call the CRYS_RC4_Stream - This function is called N times
 *                              (N = number of blocks in data each block is 1byte)
 * 3. Call the CRYS_RC4_Free to end the encryption/decryption process 
 * 4. Compare the outputted result to the expected one                                                   
 *
 **************************/                                
CRYSError_t CRYS_ATP_TST_RC4_Acceptance_NON_integrated ( void )
{

    /*** TST Variables Definitions ****/
    int                     TST_index;
    int                     Block_index ,NumOfBlocks;
    CRYSError_t             TST_Status=0;
    int                     TST_OuputLocation; /* 0 >> input!=output buffer // 1 >> input=output buffer*/
    CRYS_RC4UserContext_t   TST_ContextID_ptr;
    char                    TST_MasterTestName[TST_FUNC_STRING_LEN] = "CRYS_ATP_TST_RC4_Acceptance_NON_integrated";

    
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"*********************** \n"));
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"** CRYS_ATP_TST_RC4_Acceptance_NON_integrated Tests ******* \n"));      
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"*********************** \n \n"));

    /****************/
    /***** Start of test ********/
    /****************/
    for (TST_OuputLocation =0 ; TST_OuputLocation < 2 ;TST_OuputLocation++)
    {
        for (TST_index =0 ; TST_index < TST_NumberOf_RC4AcceptanceTests ; TST_index++) /*To run on all test vectors*/
        {
            for (TST_ATP_EncryptDecryptFlag = 0; TST_ATP_EncryptDecryptFlag < 2 ; TST_ATP_EncryptDecryptFlag++)     /*Select mode or operation 
                                                                                                          TST_OperationMode = 0 == Encrypt
                                                                                                          TST_OperationMode = 1 == Decrypt*/
            {           
        
                if (TST_OuputLocation == 0)/*Select output buffer*/
                {   
                    /* output buffer != input buffer    */
                    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," ************************ \n"));
                    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"    %s [test 1A.%d]  **\n",TST_RC4_Acceptance_TestData[TST_index].TST_Name,TST_index));   
                    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"    output buffer != input buffer                                       \n"));                    
                    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," ************************ \n"));
                }
                else
                {
                    /* output buffer == input buffer    */
                    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," ************************ \n"));
                    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"    %s [test 1B.%d]   **\n",TST_RC4_Acceptance_TestData[TST_index].TST_Name,TST_index));
                    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"    output buffer == input buffer (output buffer)                         \n"));                      
                    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," ************************ \n"));
                }
            
                TST_Status = TESTPASS;
                NumOfBlocks = TST_RC4_Acceptance_TestData[TST_index].TST_dataSize/TST_MAX_SINGLE_RC4_BLOCK_SIZE_IN_BYTS;
                
                /* calling the RC4 init function */
                /*-------------------------------*/
                TST_Status = CRYS_RC4_Init(&TST_ContextID_ptr,
                                          TST_RC4_Acceptance_TestData[TST_index].TST_Key,
                                          TST_RC4_Acceptance_TestData[TST_index].TST_KeySize);                        

                TST_ATP_CHECK_ERROR_RETURN(TST_Status,"CRYS_RC4_Init",TST_RC4_Acceptance_TestData[TST_index].TST_Name,TST_MasterTestName);
  
                
                /* calling the RC4 Block function */
                /*--------------------------------*/
                /* Debug massages */
                ATP_LOG_TST_PRINT((CRYS_ATP_TST_DBG_HIGH,"number of blocks = %1d \n",NumOfBlocks));
                ATP_LOG_TST_PRINT((CRYS_ATP_TST_DBG_HIGH,"Input Data Size [byte] = %1d \n" ,TST_RC4_Acceptance_TestData[TST_index].TST_dataSize));
                ATP_LOG_TST_PRINT((CRYS_ATP_TST_DBG_HIGH,"SingleBlockSize [byte] = %1d \n",TST_MAX_SINGLE_RC4_BLOCK_SIZE_IN_BYTS));
                
                
                if (TST_OuputLocation == 0)/* input buffer != output buffer */
                {
                    for (Block_index = 0 ; Block_index < NumOfBlocks ; Block_index++)/*RC4 block loop*/
                    {  
                        if (TST_ATP_EncryptDecryptFlag == TST_ENCRYPT)
                        { 
                            TST_Status = CRYS_RC4_Stream(&TST_ContextID_ptr,    
                                                        TST_RC4_Acceptance_TestData[TST_index].TST_input_data+(TST_MAX_SINGLE_RC4_BLOCK_SIZE_IN_BYTS*Block_index),        
                                                        TST_MAX_SINGLE_RC4_BLOCK_SIZE_IN_BYTS*sizeof(DxUint8_t), 
                                                        TST_RC4_Acceptance_TestData[TST_index].TST_output_data+(TST_MAX_SINGLE_RC4_BLOCK_SIZE_IN_BYTS*Block_index)); 

                            TST_ATP_CHECK_ERROR_RETURN(TST_Status,"CRYS_RC4_Block - Encrypt",TST_RC4_Acceptance_TestData[TST_index].TST_Name,TST_MasterTestName);                             
                        }
                        else
                        {                           
                            TST_Status = CRYS_RC4_Stream(&TST_ContextID_ptr,    
                                                        TST_RC4_Acceptance_TestData[TST_index].TST_Expected_output_data+(TST_MAX_SINGLE_RC4_BLOCK_SIZE_IN_BYTS*Block_index),        
                                                        TST_MAX_SINGLE_RC4_BLOCK_SIZE_IN_BYTS*sizeof(DxUint8_t), 
                                                        TST_RC4_Acceptance_TestData[TST_index].TST_output_data+(TST_MAX_SINGLE_RC4_BLOCK_SIZE_IN_BYTS*Block_index));        

                            TST_ATP_CHECK_ERROR_RETURN(TST_Status,"CRYS_RC4_Block - Decrypt",TST_RC4_Acceptance_TestData[TST_index].TST_Name,TST_MasterTestName);
                        }   

                                        
                    }/*End RC4 block loop*/
                }
                else /* input buffer = output buffer */
                {
                    for (Block_index =0 ; Block_index < NumOfBlocks ; Block_index++)
                    {
                        if (TST_ATP_EncryptDecryptFlag == TST_ENCRYPT)
                        {
                            /*Copying the input buffer onto output buffer not to overwrite test data*/
                            DX_VOS_FastMemCpy(TST_RC4_Acceptance_TestData[TST_index].TST_output_data+(TST_MAX_SINGLE_RC4_BLOCK_SIZE_IN_BYTS*Block_index),
                                           TST_RC4_Acceptance_TestData[TST_index].TST_input_data+(TST_MAX_SINGLE_RC4_BLOCK_SIZE_IN_BYTS*Block_index),
                                           TST_MAX_SINGLE_RC4_BLOCK_SIZE_IN_BYTS);  
                        }
                        else
                        {
                            /*Copying the input buffer onto output buffer not to overwrite test data*/
                            DX_VOS_FastMemCpy(TST_RC4_Acceptance_TestData[TST_index].TST_output_data+(TST_MAX_SINGLE_RC4_BLOCK_SIZE_IN_BYTS*Block_index),
                                           TST_RC4_Acceptance_TestData[TST_index].TST_Expected_output_data+(TST_MAX_SINGLE_RC4_BLOCK_SIZE_IN_BYTS*Block_index),
                                           TST_MAX_SINGLE_RC4_BLOCK_SIZE_IN_BYTS);  
                        }
                    }           

                    for (Block_index =0 ; Block_index < NumOfBlocks ; Block_index++)
                    {   
                        TST_Status = CRYS_RC4_Stream(&TST_ContextID_ptr,              
                                                    TST_RC4_Acceptance_TestData[TST_index].TST_output_data+(TST_MAX_SINGLE_RC4_BLOCK_SIZE_IN_BYTS*Block_index),        
                                                    TST_MAX_SINGLE_RC4_BLOCK_SIZE_IN_BYTS*sizeof(DxUint8_t), 
                                                    TST_RC4_Acceptance_TestData[TST_index].TST_output_data+(TST_MAX_SINGLE_RC4_BLOCK_SIZE_IN_BYTS*Block_index)); 
                            
                        if (TST_ATP_EncryptDecryptFlag == TST_ENCRYPT)
            {
                            TST_ATP_CHECK_ERROR_RETURN(TST_Status,"CRYS_RC4_Block Encrypt",TST_RC4_Acceptance_TestData[TST_index].TST_Name,TST_MasterTestName);
            }
                        else
            {
                            TST_ATP_CHECK_ERROR_RETURN(TST_Status,"CRYS_RC4_Block Decrypt",TST_RC4_Acceptance_TestData[TST_index].TST_Name,TST_MasterTestName);
            }
                        
                    }
                } 

                /* calling the Free function */
                 /*---------------------------*/        
                 TST_Status = CRYS_RC4_Free( &TST_ContextID_ptr );
                 
                TST_ATP_CHECK_ERROR_RETURN(TST_Status,"CRYS_RC4_Free",TST_RC4_Acceptance_TestData[TST_index].TST_Name,TST_MasterTestName);
 
                    
                            
                /* Compare the result to expected result */
                /*---------------------------------------*/
                if (TST_ATP_EncryptDecryptFlag == TST_ENCRYPT)  
                {
                TST_Status = (CRYSError_t)DX_VOS_MemCmp(TST_RC4_Acceptance_TestData[TST_index].TST_output_data ,
                                                    TST_RC4_Acceptance_TestData[TST_index].TST_Expected_output_data ,
                                                    TST_RC4_Acceptance_TestData[TST_index].TST_dataSize);
                }
                else
                {
                TST_Status = (CRYSError_t)DX_VOS_MemCmp(TST_RC4_Acceptance_TestData[TST_index].TST_output_data ,
                                                    TST_RC4_Acceptance_TestData[TST_index].TST_input_data,
                                                    TST_RC4_Acceptance_TestData[TST_index].TST_dataSize);                
                }
                
                /*Print the outputted and then the expected result after mem compare */
                ATP_LOG_TST_DisplayBuffer (CRYS_ATP_TST_DBG_HIGH,
                                            "\nData outputted by engine [output buffer]-- \n",
                                            TST_RC4_Acceptance_TestData[TST_index].TST_output_data,
                                            TST_RC4_Acceptance_TestData[TST_index].TST_dataSize);

                if (TST_ATP_EncryptDecryptFlag == TST_ENCRYPT)
                {
                    ATP_LOG_TST_DisplayBuffer (CRYS_ATP_TST_DBG_HIGH,
                                                "\nData Expected by engine [expected buffer - encrypt]--\n",
                                                TST_RC4_Acceptance_TestData[TST_index].TST_Expected_output_data,
                                                TST_RC4_Acceptance_TestData[TST_index].TST_dataSize);                 
                }
                else
                {
                    ATP_LOG_TST_DisplayBuffer (CRYS_ATP_TST_DBG_HIGH,
                                                "\nData Expected by engine [input buffer - for decrypt]--\n",
                                                TST_RC4_Acceptance_TestData[TST_index].TST_input_data,
                                                TST_RC4_Acceptance_TestData[TST_index].TST_dataSize);                     
                }           

                TST_ATP_CHECK_ERROR_RETURN(TST_Status,"DX_VOS_MemCmp",TST_RC4_Acceptance_TestData[TST_index].TST_Name,TST_MasterTestName);                   
 
                               
            }/*End of TST_ATP_EncryptDecryptFlag loop*/
        }/*End of TST_index//TST_NumberOf_RC4_AcceptanceTests*/     
    } /* End of TST_OuputLocation loop*/
  return TST_Status;
   
EXIT_ON_ERROR:
  {
   return DX_FAILURE;
  }
}/* End of CRYS_ATP_TST_RC4_Acceptance_NON_integrated*/


/*****************************************************/
/*TESTS SEPERETOR--TESTS SEPERETOR--TESTS SEPERETOR--TESTS SEPERETOR--TESTS SEPERETOR--TESTS SEPERETOR********************/
/*--TESTS SEPERETOR--TESTS SEPERETOR--TESTS SEPERETOR--TESTS SEPERETOR--TESTS SEPERETOR--TESTS SEPERETOR******************/
/*TESTS SEPERETOR--TESTS SEPERETOR--TESTS SEPERETOR--TESTS SEPERETOR--TESTS SEPERETOR--TESTS SEPERETOR********************/
/*--TESTS SEPERETOR--TESTS SEPERETOR--TESTS SEPERETOR--TESTS SEPERETOR--TESTS SEPERETOR--TESTS SEPERETOR******************/
/*****************************************************/

/***************************
 * Function Name:                                                           
 *  CRYS_ATP_TST_RC4_Acceptance_integrated      
 * 
 * Inputs:
 *  None
 *
 * Outputs:
 *  CRYSError_t - Function error return                                     
 *
 * Description:                                                                 
 *  This function Is a Acceptance test for RC4 non integrated API's                         
 *  This function Encrypts and Decrypts known vectors using RC4 
 *  Vector sizes used (in bytes) - 16/32/45/512/1536
 *  Key Size used (in bytes)    - 16/32/45/256 *  This also outputs the results to an output buffer or the same input buffer
 * Algorithm:       
 * 1. Call the CRYS_RC4_to Preform the encryption/decryption process
 * 2. Compare the outputted result to the expected one                                                   
 *
 **************************/    
CRYSError_t CRYS_ATP_TST_RC4_Acceptance_Integrated ( void )
{
    /*** TST Variables Definitions ****/
    int         TST_index, Block_index ,NumOfBlocks;
    CRYSError_t TST_Status=0;
    int         TST_OuputLocation; /* 0 >> input!=output buffer // 1 >> input=output buffer*/
    char        TST_MasterTestName[TST_FUNC_STRING_LEN] = "CRYS_ATP_TST_RC4_Acceptance_Integrated";
    /*** TST Variables initialization ***/
    
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," *********************** \n"));
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," ** CRYS_ATP_TST_RC4_Acceptance_Integrated Tests     ******* \n"));     
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," *********************** \n \n"));

    
    /****************/
    /***** Start of test ********/
    /****************/
    for (TST_OuputLocation =0 ; TST_OuputLocation < 2 ;TST_OuputLocation++)
    {
        for (TST_index =0 ; TST_index < TST_NumberOf_RC4AcceptanceTests ; TST_index++) /*To run on all test vectors*/
        {
            for (TST_ATP_EncryptDecryptFlag = 0; TST_ATP_EncryptDecryptFlag < 2 ; TST_ATP_EncryptDecryptFlag++) /*Select mode or operation 
                                                                                                      TST_OperationMode = 0 == Encrypt
                                                                                                      TST_OperationMode = 1 == Decrypt*/
            {
            if (TST_OuputLocation == 0)/*Select output buffer*/
            {   
                /* output buffer != input buffer    */
                ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," ************************ \n"));
                ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"    %s [test 2A.%d]  **\n",TST_RC4_Acceptance_TestData[TST_index].TST_Name,TST_index));   
                ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"    output buffer != input buffer                                       \n"));                    
                ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," ************************ \n"));
            }
            else
            {
                /* output buffer == input buffer    */
                ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," ************************ \n"));
                ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"    %s [test 2B.%d]   **\n",TST_RC4_Acceptance_TestData[TST_index].TST_Name,TST_index));
                ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"    output buffer == input buffer (output buffer)                         \n"));                      
                ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," ************************ \n"));
            }
            
            TST_Status = TESTPASS;
            NumOfBlocks = TST_RC4_Acceptance_TestData[TST_index].TST_dataSize/TST_MAX_SINGLE_RC4_BLOCK_SIZE_IN_BYTS;
                    
            /* calling the RC4 integrated function */
            /*-------------------------------------*/ 
            if (TST_OuputLocation == 0)/* input buffer != output buffer */
            {
                if (TST_ATP_EncryptDecryptFlag ==0) 
                {
                    TST_ATP_StartPerformanceTimer(&TST_Timer);

                    TST_Status = CRYS_RC4(TST_RC4_Acceptance_TestData[TST_index].TST_Key,
                                             TST_RC4_Acceptance_TestData[TST_index].TST_KeySize,
                                             TST_RC4_Acceptance_TestData[TST_index].TST_input_data,
                                             TST_RC4_Acceptance_TestData[TST_index].TST_dataSize,
                                             TST_RC4_Acceptance_TestData[TST_index].TST_output_data); 

                    TST_ATP_GetPerformanceTimer(&TST_Timer);
                    TST_ATP_CalcPerformance(TST_RC4_Acceptance_TestData[TST_index].TST_dataSize);
                }
                else
                {
                    TST_ATP_StartPerformanceTimer(&TST_Timer);

                    TST_Status = CRYS_RC4(TST_RC4_Acceptance_TestData[TST_index].TST_Key,
                                             TST_RC4_Acceptance_TestData[TST_index].TST_KeySize,
                                             TST_RC4_Acceptance_TestData[TST_index].TST_Expected_output_data,
                                             TST_RC4_Acceptance_TestData[TST_index].TST_dataSize,
                                             TST_RC4_Acceptance_TestData[TST_index].TST_output_data);
                    
                    TST_ATP_GetPerformanceTimer(&TST_Timer);
                    TST_ATP_CalcPerformance(TST_RC4_Acceptance_TestData[TST_index].TST_dataSize);
                }
            }
            else /* input buffer = output buffer */
            {
                for (Block_index =0 ; Block_index < NumOfBlocks ; Block_index++)
                {
                    if (TST_ATP_EncryptDecryptFlag == TST_ENCRYPT)
                    {
                    /*Copying the input buffer onto output buffer not to overwrite test data*/
                        DX_VOS_FastMemCpy(TST_RC4_Acceptance_TestData[TST_index].TST_output_data+(TST_MAX_SINGLE_RC4_BLOCK_SIZE_IN_BYTS*Block_index),
                                       TST_RC4_Acceptance_TestData[TST_index].TST_input_data+(TST_MAX_SINGLE_RC4_BLOCK_SIZE_IN_BYTS*Block_index),
                                       TST_MAX_SINGLE_RC4_BLOCK_SIZE_IN_BYTS);  
                    }
                    else
                    {
                    /*Copying the input buffer onto output buffer not to overwrite test data*/
                        DX_VOS_FastMemCpy(TST_RC4_Acceptance_TestData[TST_index].TST_output_data+(TST_MAX_SINGLE_RC4_BLOCK_SIZE_IN_BYTS*Block_index),
                                       TST_RC4_Acceptance_TestData[TST_index].TST_Expected_output_data+(TST_MAX_SINGLE_RC4_BLOCK_SIZE_IN_BYTS*Block_index),
                                       TST_MAX_SINGLE_RC4_BLOCK_SIZE_IN_BYTS);  
                    }
                }  
                TST_ATP_StartPerformanceTimer(&TST_Timer);

                TST_Status = CRYS_RC4(TST_RC4_Acceptance_TestData[TST_index].TST_Key,
                                         TST_RC4_Acceptance_TestData[TST_index].TST_KeySize,
                                         TST_RC4_Acceptance_TestData[TST_index].TST_output_data,
                                         TST_RC4_Acceptance_TestData[TST_index].TST_dataSize,
                                         TST_RC4_Acceptance_TestData[TST_index].TST_output_data); 

                TST_ATP_GetPerformanceTimer(&TST_Timer);
                TST_ATP_CalcPerformance(TST_RC4_Acceptance_TestData[TST_index].TST_dataSize);
            } 
            
            if (TST_ATP_EncryptDecryptFlag == TST_ENCRYPT)
      {
                TST_ATP_CHECK_ERROR_RETURN(TST_Status,"CRYS_RC4 Encrypt",TST_RC4_Acceptance_TestData[TST_index].TST_Name,TST_MasterTestName);
      }
            else
      {
                TST_ATP_CHECK_ERROR_RETURN(TST_Status,"CRYS_RC4 Decrypt",TST_RC4_Acceptance_TestData[TST_index].TST_Name,TST_MasterTestName);
      }

 
            
            /* Debug massages */
            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"Input Data Size [byte] = %1d \n" ,TST_RC4_Acceptance_TestData[TST_index].TST_dataSize));
                        
            /* Compare the result to expected result */
            /*---------------------------------------*/                                                             
            if (TST_ATP_EncryptDecryptFlag == TST_ENCRYPT)  
            {
            TST_Status = (CRYSError_t)DX_VOS_MemCmp(TST_RC4_Acceptance_TestData[TST_index].TST_output_data ,
                                                TST_RC4_Acceptance_TestData[TST_index].TST_Expected_output_data ,
                                                TST_RC4_Acceptance_TestData[TST_index].TST_dataSize);
            }
            else
            {
            TST_Status = (CRYSError_t)DX_VOS_MemCmp(TST_RC4_Acceptance_TestData[TST_index].TST_output_data ,
                                                TST_RC4_Acceptance_TestData[TST_index].TST_input_data,
                                                TST_RC4_Acceptance_TestData[TST_index].TST_dataSize);                
            }

            /*Print the outputted and then the expected result after mem compare */
            ATP_LOG_TST_DisplayBuffer (CRYS_ATP_TST_DBG_HIGH,
                                        "\nData outputted by engine [output buffer]-- \n",
                                        TST_RC4_Acceptance_TestData[TST_index].TST_output_data,
                                        TST_RC4_Acceptance_TestData[TST_index].TST_dataSize);

            if (TST_ATP_EncryptDecryptFlag == TST_ENCRYPT)
            {
                ATP_LOG_TST_DisplayBuffer (CRYS_ATP_TST_DBG_HIGH,
                                            "\nData Expected by engine [expected buffer - encrypt]--\n",
                                            TST_RC4_Acceptance_TestData[TST_index].TST_Expected_output_data,
                                            TST_RC4_Acceptance_TestData[TST_index].TST_dataSize);                 
            }
            else
            {
                ATP_LOG_TST_DisplayBuffer (CRYS_ATP_TST_DBG_HIGH,
                                            "\nData Expected by engine [input buffer - for decrypt]--\n",
                                            TST_RC4_Acceptance_TestData[TST_index].TST_input_data,
                                            TST_RC4_Acceptance_TestData[TST_index].TST_dataSize);                     
            }               
            
            TST_ATP_CHECK_ERROR_RETURN(TST_Status,"DX_VOS_MemCmp",TST_RC4_Acceptance_TestData[TST_index].TST_Name,TST_MasterTestName);


            }/* End of TST_ATP_EncryptDecryptFlag*/
        }/*End of TST_index//TST_NumberOf_RC4_AcceptanceTests*/     
    } /* End of TST_OuputLocation loop*/
  return TST_Status;
   
EXIT_ON_ERROR:
  {
   return DX_FAILURE;
  }
}/* End of CRYS_ATP_TST_RC4_Acceptance_Integrated */

/*****************************************************/
/*TESTS SEPERETOR--TESTS SEPERETOR--TESTS SEPERETOR--TESTS SEPERETOR--TESTS SEPERETOR--TESTS SEPERETOR********************/
/*--TESTS SEPERETOR--TESTS SEPERETOR--TESTS SEPERETOR--TESTS SEPERETOR--TESTS SEPERETOR--TESTS SEPERETOR******************/
/*TESTS SEPERETOR--TESTS SEPERETOR--TESTS SEPERETOR--TESTS SEPERETOR--TESTS SEPERETOR--TESTS SEPERETOR********************/
/*--TESTS SEPERETOR--TESTS SEPERETOR--TESTS SEPERETOR--TESTS SEPERETOR--TESTS SEPERETOR--TESTS SEPERETOR******************/
/*****************************************************/

#endif

